/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.hibernate;

import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.binding.PropertyWrapper;
import org.loom.mapping.ActionMapping;
import org.loom.validator.AbstractRequiredValidator;
import org.loom.validator.RequiredValidatorFactory;


/**
 * Processes Hibernate Validator annotations related to Required validations: NotEmpty and NotNull
 * @author icoloma
 */
public class HibernateRequiredValidationAnnotationProcessor extends AbstractInterceptorAnnotationProcessor {

	@Override
	@SuppressWarnings("unchecked")
	public void process(AnnotationMetadata metadata, ActionMapping mapping) {

		for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(NotEmpty.class, NotNull.class)) {
		
			NotEmpty notEmpty = property.getAnnotation(NotEmpty.class);
			NotNull notNull = property.getAnnotation(NotNull.class);
			
			if (notEmpty != null || notNull != null) {
				Class<?> propertyClass = ((PropertyWrapper)property.getAnnotationContainer()).getPropertyClass();
				AbstractRequiredValidator<?> validator = RequiredValidatorFactory.createValidator(propertyClass);
				validator.setPropertyPath(property.getPropertyPath());
				mapping.addValidator(property.getEventFilter(), validator);
			}
		}
		
	}

}
