package org.loom.addons.id;


/**
 * Generates public IDs to be used in RESTful URLs 
 * @author icoloma
 *
 */
public interface IdGeneratorService {

	/**
	 * Generate a valid public ID to use for RESTful URIs.
	 * This method will take the proposed text and calculate a public ID to use in RESTful URIs,
	 * e.g:
	 * 
	 * <ul><li>"Some text" -> "some-text"</li>
	 * <li>"a@b.c" -> "abc"</li></ul>
	 * 
	 * If a candidate already exists in the database it will get appended an index, so
	 * "some-text" will become "some-text-1", etc.
	 * 
	 * @param persistentClass the persistent class to generate the public ID for
	 * @param idFieldName the name of the persistent field that will store the key
	 * @param keyText the text used to calculate the key
	 * @return the generated key
	 */
	public String generateId(Class<?> persistentClass, String idFieldName, String keyText);
	
}
