/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.multiupload;

import java.util.regex.Pattern;

import org.loom.annotation.MultiUpload;
import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.mapping.ActionMapping;
import org.loom.util.PropertyUtils;


/**
 * Processes {@link MultiUpload} annotations
 * @author icoloma
 *
 */
public class MultiUploadAnnotationProcessor extends AbstractInterceptorAnnotationProcessor {

	@SuppressWarnings("unchecked")
	public void process(AnnotationMetadata metadata, ActionMapping mapping) {
		for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(MultiUpload.class)) {
			MultiUpload annotation = property.getAnnotation(MultiUpload.class);
			MultiUploadInterceptor interceptor = getInterceptorFactory().newInstance(MultiUploadInterceptor.class);
			if (annotation.maxFileSize() != -1) {
				interceptor.setMaxFileSize(annotation.maxFileSize());
			}
			if (annotation.filenameMaskPattern().length() > 0) {
				Pattern p = Pattern.compile(annotation.filenameMaskPattern(), Pattern.CASE_INSENSITIVE);
				interceptor.setFilenameMaskPattern(p);
			}
			interceptor.setPropertyPath(PropertyUtils.concatPropertyPath(property.getPropertyPath(), annotation.propertyPath()));
			mapping.addInterceptor(property.getEventFilter(annotation), interceptor);
		}
	}
	

}
