/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.ServletException;

import org.loom.json.JsonMarshaller;
import org.loom.resolution.JsonResolution;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.LoomServletResponse;

/**
 * A Resolution that returns tree nodes in the JSON format
 * @author icoloma
 */
public class JsonTreeResolution<T> extends JsonResolution {

	/** the renderer that converts each node to its JSON representation */
	protected JsonNodeRenderer<T> renderer;

	/** the list of nodes to display */
	protected Collection<T> nodes;
	
	public JsonTreeResolution(JsonNodeRenderer<T> renderer) {
		this.renderer = renderer;
	}
	
	@Override
	public void resolve(LoomServletRequest request, LoomServletResponse response) throws IOException, ServletException {
		
		List<JsonMarshaller> renderedNodes = new ArrayList<JsonMarshaller>();
		for (T node : nodes) {
			renderedNodes.add(renderer.renderNode(0, node));
		}
		getMarshaller().add("nodes", renderedNodes);
		super.resolve(request, response);
	}
	
	public void setNodes(Collection<T> nodes) {
		this.nodes = nodes;
	}

	public Collection<T> getNodes() {
		return nodes;
	}
	
}
