/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.confirmation;

import javax.servlet.http.Cookie;
import org.loom.addons.confirmation.ConfirmationLogger;
import org.loom.addons.confirmation.ConfirmationType;
import org.loom.addons.confirmation.DefaultConfirmationLogger;
import org.loom.interceptor.ConfigurableInterceptor;
import org.loom.interceptor.ValidateInterceptor;
import org.loom.mapping.ParsedAction;
import org.loom.resolution.Resolution;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.LoomServletResponse;
import org.loom.servlet.params.ParameterValue;
import org.loom.tags.Button;
import org.loom.tags.HtmlTag;
import org.loom.tags.Link;
import org.loom.validator.ButtonDecorator;
import org.loom.validator.LinkDecorator;

public class ConfirmationInterceptor
implements ValidateInterceptor,
LinkDecorator,
ButtonDecorator,
ConfigurableInterceptor {
    public static String CONFIRMATION = "confirmation";
    private String id;
    private String message;
    private ConfirmationType type;
    private ConfirmationLogger log = new DefaultConfirmationLogger();
    private String paramName;

    public boolean requiresConfiguration() {
        return false;
    }

    public void validate() {
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setId(String id) {
        this.id = id;
        this.paramName = "_confirmation-" + id;
    }

    public Resolution beforeValidate(ParsedAction action) {
        LoomServletResponse response;
        LoomServletRequest request = action.getRequest();
        if (this.isConfirmed(request, response = action.getResponse())) {
            return null;
        }
        StringBuilder url = request.getRequestUrlWithParameters();
        if (url.indexOf(this.paramName) == -1) {
            url.append(url.indexOf("?") == -1 ? (char)'?' : '&').append(this.paramName).append("=true");
        }
        request.setAttribute("confirmKey", (Object)(this.message != null ? this.message : this.id));
        request.setAttribute("confirmUrl", (Object)url.toString());
        return action.getAction().getContext().getResolutionFactory().forward("/confirmation.jsp");
    }

    protected boolean isConfirmed(LoomServletRequest request, LoomServletResponse response) {
        ParameterValue paramValue = request.getParameterValue(this.paramName);
        boolean userAcceptsNow = paramValue != null;
        boolean confirmed = false;
        if (ConfirmationType.CONFIRMATION.equals((Object)this.type)) {
            confirmed = userAcceptsNow;
            if (confirmed) {
                this.log.logAccepts(request, this.type, this.id);
            }
        } else if (ConfirmationType.DISCLAIMER.equals((Object)this.type)) {
            Cookie cookieValue = request.getCookie(this.paramName);
            if (userAcceptsNow && cookieValue == null) {
                if (response != null) {
                    response.addCookie(new Cookie(this.paramName, "true"));
                }
                this.log.logAccepts(request, this.type, this.id);
                confirmed = true;
            } else {
                confirmed = cookieValue != null && "true".equals(cookieValue.getValue());
            }
        } else {
            throw new IllegalArgumentException("Unrecognized ConfirmationType: " + (Object)((Object)this.type));
        }
        return confirmed;
    }

    protected boolean isConfirmed(LoomServletRequest request) {
        return this.isConfirmed(request, null);
    }

    public void setType(ConfirmationType type) {
        this.type = type;
    }

    public void decorateImpl(HtmlTag tag) {
        if (!this.isConfirmed(tag.getRequest())) {
            tag.addCssClass(CONFIRMATION);
            tag.setExtendedAttribute("confirmation-message", (Object)this.message);
            tag.setExtendedAttribute("confirmation-id", (Object)this.id);
        }
    }

    public void decorate(Link link) {
        this.decorateImpl((HtmlTag)link);
    }

    public void decorate(Button button) {
        this.decorateImpl((HtmlTag)button);
    }
}

