/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.hibernate;

import java.math.BigDecimal;
import org.hibernate.validator.Max;
import org.hibernate.validator.Min;
import org.hibernate.validator.Range;
import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.mapping.ActionMapping;
import org.loom.validator.NumberValidator;
import org.loom.validator.PropertyValidator;

public class HibernateNumberValidationAnnotationProcessor
extends AbstractInterceptorAnnotationProcessor {
    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(new Class[]{Max.class, Min.class, Range.class})) {
            Max max = (Max)property.getAnnotation(Max.class);
            Min min = (Min)property.getAnnotation(Min.class);
            Range range = (Range)property.getAnnotation(Range.class);
            if (max == null && min == null && range == null) continue;
            NumberValidator validator = new NumberValidator();
            if (max != null) {
                validator.setMaxValue(new BigDecimal(max.value()));
                validator.setExcludeMax(false);
            }
            if (min != null) {
                validator.setMinValue(new BigDecimal(min.value()));
            }
            if (range != null) {
                if (range.min() != Long.MIN_VALUE) {
                    validator.setMinValue(new BigDecimal(range.min()));
                }
                if (range.max() != Long.MAX_VALUE) {
                    validator.setMaxValue(new BigDecimal(range.max()));
                }
            }
            validator.setPropertyPath(property.getPropertyPath());
            mapping.addValidator(property.getEventFilter(), (PropertyValidator)validator);
        }
    }
}

