/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.multiupload;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import org.loom.addons.multiupload.MultiUploadInterceptor;
import org.loom.annotation.MultiUpload;
import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.interceptor.Interceptor;
import org.loom.mapping.ActionMapping;
import org.loom.util.PropertyUtils;

public class MultiUploadAnnotationProcessor
extends AbstractInterceptorAnnotationProcessor {
    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(new Class[]{MultiUpload.class})) {
            MultiUpload annotation = (MultiUpload)property.getAnnotation(MultiUpload.class);
            MultiUploadInterceptor interceptor = (MultiUploadInterceptor)this.getInterceptorFactory().newInstance(MultiUploadInterceptor.class);
            if (annotation.maxFileSize() != -1L) {
                interceptor.setMaxFileSize(annotation.maxFileSize());
            }
            if (annotation.filenameMaskPattern().length() > 0) {
                Pattern p = Pattern.compile(annotation.filenameMaskPattern(), 2);
                interceptor.setFilenameMaskPattern(p);
            }
            interceptor.setPropertyPath(PropertyUtils.concatPropertyPath((String[])new String[]{property.getPropertyPath(), annotation.propertyPath()}));
            mapping.addInterceptor(property.getEventFilter((Annotation)annotation), (Interceptor)interceptor);
        }
    }
}

