/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.multiupload;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.loom.i18n.FileSizeFormatter;
import org.loom.mapping.ParsedAction;
import org.loom.persistence.file.PersistentFile;
import org.loom.tags.AbstractDecoratedTag;
import org.loom.tags.WriterWrapper;
import org.loom.tags.core.InputFileTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiUploadTag
extends AbstractDecoratedTag {
    private String name;
    private boolean accessible = true;
    private Integer maxRows;
    private FileSizeFormatter fileSizeFormatter = new FileSizeFormatter();

    protected Object getValueAsObject() {
        ParsedAction parsedAction = this.request.getParsedAction();
        if (parsedAction == null) {
            return null;
        }
        return parsedAction.getPropertyAsObject(this.name);
    }

    public void doTagImpl() throws JspException, IOException {
        this.fileSizeFormatter.setMessagesRepository(this.getMessagesRepository());
        this.request.getCurrentForm().setMultipart(true);
        if (this.maxRows == null && this.accessible) {
            this.maxRows = 10;
        }
        this.out.print((CharSequence)"<div");
        this.out.printAttribute("class", (Object)"multiupload");
        this.printParentAttributes();
        this.out.print((CharSequence)">\n");
        List files = (List)this.getValueAsObject();
        int index = 0;
        if (files != null && files.size() > 0) {
            this.out.print((CharSequence)"<ul>\n");
            for (PersistentFile file : files) {
                this.render(this.out, file, index++);
            }
            this.out.print((CharSequence)"</ul>\n");
        }
        if (this.accessible) {
            this.out.print((CharSequence)"<noscript>\n<ul>\n");
            InputFileTag file = new InputFileTag();
            file.setWriter(this.out);
            file.setForm(this.request.getCurrentForm());
            file.setRequest(this.request);
            for (int i = 0; i < this.maxRows; ++i) {
                file.setName(this.name + '[' + (index + i) + ']');
                this.out.print((CharSequence)"<li>");
                file.doTagImpl();
                this.out.print((CharSequence)"</li>\n");
            }
            this.out.print((CharSequence)"</ul>\n</noscript>\n");
        }
        this.out.print((CharSequence)"</div>\n");
    }

    protected void render(WriterWrapper<?> out, PersistentFile file, int index) throws IOException {
        String filename = file.getFilename();
        out.print((CharSequence)"<li");
        String extension = StringUtils.substringAfterLast((String)filename, (String)".");
        if (extension != null) {
            out.printAttribute("class", (Object)("file-" + extension));
        }
        out.print((CharSequence)">\n");
        out.print((CharSequence)"<input type=\"checkbox\"");
        out.printAttribute("name", (Object)("_uploaded-" + this.name + '[' + index + ']'));
        out.printAttribute("value", (Object)file.getId());
        out.printAttribute("class", (Object)"checkbox");
        out.print((CharSequence)" checked/>");
        out.print((CharSequence)"<span>");
        out.print((CharSequence)filename);
        if (file.getFileSize() != null) {
            out.print((CharSequence)" (").print((CharSequence)this.fileSizeFormatter.format((Number)file.getFileSize())).print((CharSequence)")");
        }
        out.print((CharSequence)"</span>\n");
        out.print((CharSequence)"</li>\n");
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setExtendedAttribute("input-name", name);
    }
}

