/**
 * Creates a slider under a textarea to change its height
 * @author rgrocha
 * @author icoloma
 */
loom.ui.ResizableTextArea = Class.create({

	initialize : function(textarea) {

		this.textarea = $(textarea);
		var c = Element.wrap(this.textarea, 'div', { className: 'resizable' });
		this.container = c;
		this.grippie = new Element('div', { className: 'grippie' });
		c.insert(this.grippie);

		this.startDrag = this.startDrag.bindAsEventListener(this);
		this.performDrag = this.performDrag.bindAsEventListener(this);
		this.endDrag = this.endDrag.bindAsEventListener(this);

		this.grippie.observe('mousedown', this.startDrag);
	},

	startDrag : function (e) {
		e.stop();
		this.staticOffset = this.textarea.getHeight() - Event.pointerY(e);
		this.textarea.setStyle({opacity : 0.25});

		document.observe('mousemove', this.performDrag);
		document.observe('mouseup', this.endDrag);
	},

	performDrag : function (e) {
		e.stop();
		this.textarea.setStyle({'height' : Math.max(32, this.staticOffset + Event.pointerY(e)) + 'px'});
	},

	endDrag : function (e) {
		document.stopObserving('mousemove', this.performDrag);
		document.stopObserving('mouseup', this.endDrag);
		this.textarea.setStyle({opacity : 1});
	}
    
});

