/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.confirmation;

import org.apache.commons.lang.StringUtils;
import org.loom.annotation.processor.AbstractInjectedInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.Event;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Process RequiresConfirmation annotations
 * @author icoloma
 */
@Component
public class RequiresConfirmationAnnotationProcessor extends AbstractInjectedInterceptorAnnotationProcessor<ConfirmationInterceptor> {

	@Autowired
	private MessagesRepositoryFactory messagesRepositoryFactory;

	public RequiresConfirmationAnnotationProcessor() {
		super(ConfirmationInterceptor.class);
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public void process(AnnotationMetadata metadata, ActionMapping mapping) {
		for (FilteredAnnotationContainer methodWrapper : metadata.getAnnotatedMethods(RequiresConfirmation.class)) {
			RequiresConfirmation annotation = methodWrapper.getAnnotation(RequiresConfirmation.class);
			Event event = mapping.getEvent(methodWrapper.getName());
			ConfirmationInterceptor interceptor = getInterceptor();
			interceptor.setId(annotation.id());
			interceptor.setType(annotation.type());
			String message = annotation.message();
			if (!StringUtils.isEmpty(message)) {
				interceptor.setMessage(message);
			} else {
				message = annotation.id();
			}
			event.addInterceptor(interceptor);

			// add the json keys 
			messagesRepositoryFactory.addBrowserMessage(message + ".title");
			messagesRepositoryFactory.addBrowserMessage(message + ".message");
			messagesRepositoryFactory.addBrowserMessage(message + ".accept");
			messagesRepositoryFactory.addBrowserMessage(message + ".cancel");
		}
	}

	public void setMessagesRepositoryFactory( MessagesRepositoryFactory messagesRepositoryFactory) {
		this.messagesRepositoryFactory = messagesRepositoryFactory;
	}

}
