/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.hibernate;

import org.hibernate.validator.Future;
import org.hibernate.validator.Past;
import org.loom.annotation.processor.AbstractAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.mapping.ActionMapping;
import org.loom.validator.ValueParser;
import org.loom.validator.date.DateValidator;
import org.loom.validator.date.DateValue;


/**
 * Processes Hibernate Validator annotations related to Date validations: Future and Past
 * @author icoloma
 */
public class HibernateDateValidationAnnotationProcessor extends AbstractAnnotationProcessor {

	@Override
	@SuppressWarnings("unchecked")
	public void process(AnnotationMetadata metadata, ActionMapping mapping) {

		for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(Past.class, Future.class) ) {
	
			org.hibernate.validator.Future future = property.getAnnotation(org.hibernate.validator.Future.class);
			org.hibernate.validator.Past past = property.getAnnotation(org.hibernate.validator.Past.class);
			
			if (future != null || past != null) {
				
				DateValidator validator = new DateValidator();
				if (future != null && past != null) {
					throw new IllegalArgumentException("@Future and @Past specified at the same time for property " + property.getPropertyPath());
				}
				DateValue dateValue = ValueParser.parseDateValue("today");
				if (future != null) {
					validator.setMinValue(dateValue);
					validator.setExcludeMin(true);
				}
				if (past != null) {
					validator.setMaxValue(dateValue);
					validator.setExcludeMax(true);
				}
				validator.setPropertyPath(property.getPropertyPath());
				mapping.addValidator(property.getEventFilter(), validator);
			}
		}
		
	}
	

}
