/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.hibernate;

import java.math.BigDecimal;

import org.loom.annotation.processor.AbstractAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.mapping.ActionMapping;
import org.loom.validator.NumberValidator;


/**
 * Processes Hibernate Validator annotations related to Number validations: Max, Min and Range
 * @author icoloma
 */
public class HibernateNumberValidationAnnotationProcessor extends AbstractAnnotationProcessor {

	@Override
	@SuppressWarnings("unchecked")
	public void process(AnnotationMetadata metadata, ActionMapping mapping) {

		for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(org.hibernate.validator.Max.class, org.hibernate.validator.Min.class, org.hibernate.validator.Range.class)) {
		
			org.hibernate.validator.Max max = property.getAnnotation(org.hibernate.validator.Max.class);
			org.hibernate.validator.Min min = property.getAnnotation(org.hibernate.validator.Min.class);
			org.hibernate.validator.Range range = property.getAnnotation(org.hibernate.validator.Range.class);
			
			if (max != null || min != null || range != null) {
				NumberValidator validator = new NumberValidator();
				if (max != null) {
					validator.setMaxValue(new BigDecimal(max.value()));
					validator.setExcludeMax(false);
				}
				if (min != null) {
					validator.setMinValue(new BigDecimal(min.value()));
				}
				if (range != null) {
					if (range.min() != Long.MIN_VALUE) {
						validator.setMinValue(new BigDecimal(range.min()));
					}
					if (range.max() != Long.MAX_VALUE) {
						validator.setMaxValue(new BigDecimal(range.max()));
					}
				}
				validator.setPropertyPath(property.getPropertyPath());
				mapping.addValidator(property.getEventFilter(), validator);
			}
		}
		
	}

}
