package org.loom.addons.id;

import javax.persistence.PersistenceContext;

import org.loom.persistence.ExtendedEntityManager;
import org.loom.util.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IdGeneratorServiceImpl implements IdGeneratorService {

	@PersistenceContext
	private ExtendedEntityManager entityManager;
	
	@Transactional
	public String generateId(Class<?> persistentClass, String idFieldName, String keyText) {
		// get an id
		String candidateId = StringUtils.generateIdentifier(keyText);
		
		// guarantee uniqueness
		Number n = (Number)entityManager.findSingle("select count(o) from " + persistentClass.getName() + " o where o." + idFieldName + " like ?", candidateId + '%');
		if (n.intValue() > 0) {
			candidateId = candidateId + "-" + n;
		}
		return candidateId;
	}
	
}
