/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.addons.multiupload;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.loom.servlet.params.FileParameterValue;

/**
 * Data of a file stored with the {@link MultiUploadInterceptor}
 * @author Ignacio Coloma
 */
public class StoredFileData {

	/** name of the bound property */
	private String propertyName;
	
	/** key of the file stored in the database */
	private Serializable storedKey;

	/** the corresponding file name */
	private FileParameterValue fileValue;
	
	public StoredFileData(FileParameterValue fileValue, Serializable storedKey) {
		this.propertyName = StringUtils.substringBeforeLast(fileValue.getName(), ".contents");
		this.fileValue = fileValue;
		this.storedKey = storedKey;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public void setPropertyName(String filename) {
		this.propertyName = filename;
	}

	public Serializable getStoredKey() {
		return storedKey;
	}

	public void setStoredKey(Serializable storedKey) {
		this.storedKey = storedKey;
	}

	public FileParameterValue getFileValue() {
		return fileValue;
	}

	public void setFileValue(FileParameterValue fileValue) {
		this.fileValue = fileValue;
	}
	
	
}
