/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.autocompleter;

import java.util.Map;
import org.loom.addons.autocompleter.AbstractAutocompletedConverter;
import org.loom.addons.autocompleter.Autocompleted;
import org.loom.addons.autocompleter.AutocompletedConverter;
import org.loom.addons.autocompleter.MultipleAutocompletedConverter;
import org.loom.binding.PropertyWrapper;
import org.loom.converter.Converter;
import org.loom.converter.ConverterFactory;
import org.loom.exception.ConfigException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class AutocompletedConverterFactory
implements ConverterFactory,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Converter getConverter(PropertyWrapper propertyWrapper) {
        AbstractAutocompletedConverter converter;
        Autocompleted annotation = (Autocompleted)propertyWrapper.getAnnotation(Autocompleted.class);
        if (annotation == null) {
            return null;
        }
        if (annotation.separatorTokens().length() > 0) {
            converter = this.getMultipleValueConverter();
            ((MultipleAutocompletedConverter)converter).setSeparatorTokens(annotation.separatorTokens());
            converter.setPersistentClass(propertyWrapper.getNextPropertyClass());
        } else {
            converter = this.getSingleValueConverter();
            converter.setPersistentClass(propertyWrapper.getPropertyClass());
        }
        converter.setConvertedClass(propertyWrapper.getPropertyClass());
        if (annotation.query().length() > 0) {
            converter.setQuery(annotation.query());
        }
        converter.setPropertyName(annotation.propertyName());
        return converter;
    }

    protected MultipleAutocompletedConverter getMultipleValueConverter() {
        return this.createConverter(MultipleAutocompletedConverter.class);
    }

    protected AutocompletedConverter getSingleValueConverter() {
        return this.createConverter(AutocompletedConverter.class);
    }

    private <T> T createConverter(Class<T> converterClass) {
        Map m = this.applicationContext.getBeansOfType(converterClass);
        if (m.isEmpty()) {
            throw new ConfigException("No converter with type " + converterClass.getName() + " has been found");
        }
        return (T)m.values().iterator().next();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

