/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.autocompleter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.NoResultException;
import org.apache.commons.lang.StringUtils;
import org.loom.addons.autocompleter.AbstractAutocompletedConverter;
import org.loom.converter.Converter;
import org.loom.i18n.Messages;
import org.loom.i18n.MessagesRepository;
import org.loom.servlet.params.ParameterValue;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class MultipleAutocompletedConverter
extends AbstractAutocompletedConverter {
    private String separatorTokens;

    public Object getAsObject(ParameterValue paramValue, Messages messages, MessagesRepository repository) {
        int i = 0;
        Collection<?> result = this.createCollection();
        ArrayList<String> wrongValues = new ArrayList<String>();
        String sv = paramValue.getString();
        if (sv != null && sv.length() > 0) {
            for (String v : StringUtils.split((String)sv, (String)this.separatorTokens)) {
                try {
                    result.add(this.retrieveEntity(v));
                }
                catch (NoResultException e) {
                    wrongValues.add(v);
                }
                ++i;
            }
        }
        if (wrongValues.isEmpty()) {
            return result;
        }
        messages.addConversionErrorMessage("persistence.multipleAutocompletedEntityNotFound", paramValue, (Converter)this).addArg("wrongValues", wrongValues);
        return null;
    }

    private Collection<?> createCollection() {
        return Set.class.isAssignableFrom(this.getConvertedClass()) ? new LinkedHashSet() : new ArrayList();
    }

    public String getAsText(Object value, MessagesRepository repository) {
        if (value == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator i = ((Iterable)value).iterator();
        while (i.hasNext()) {
            buffer.append(this.getPropertyWrapper().get(i.next(), false));
            if (!i.hasNext()) continue;
            buffer.append(this.separatorTokens.charAt(0));
        }
        return buffer.toString();
    }

    public void setSeparatorTokens(String tokenSeparators) {
        this.separatorTokens = tokenSeparators;
    }

    public String getSeparatorTokens() {
        return this.separatorTokens;
    }
}

