/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.captcha;

import org.loom.addons.captcha.Captcha;
import org.loom.addons.captcha.CaptchaInterceptor;
import org.loom.annotation.processor.AbstractInjectedInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.exception.ConfigException;
import org.loom.exception.EventNotFoundException;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.Event;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class CaptchaAnnotationProcessor
extends AbstractInjectedInterceptorAnnotationProcessor<CaptchaInterceptor> {
    @Autowired
    private MessagesRepositoryFactory messagesRepositoryFactory;

    public CaptchaAnnotationProcessor() {
        super(CaptchaInterceptor.class);
    }

    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer methodWrapper : metadata.getAnnotatedMethods(new Class[]{Captcha.class})) {
            try {
                Event event = mapping.getEvent(methodWrapper.getName());
                event.addInterceptor(this.getInterceptor());
                this.messagesRepositoryFactory.addBrowserMessage("captcha.refreshCaptcha");
            }
            catch (EventNotFoundException e) {
                throw new ConfigException("@Captcha can only be used with Event methods", (Throwable)e);
            }
        }
    }

    public void setMessagesRepositoryFactory(MessagesRepositoryFactory messagesRepositoryFactory) {
        this.messagesRepositoryFactory = messagesRepositoryFactory;
    }
}

