/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.captcha;

import com.octo.captcha.service.CaptchaService;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.loom.interceptor.ExecuteInterceptor;
import org.loom.interceptor.FinallyListener;
import org.loom.mapping.ParsedAction;
import org.loom.resolution.Resolution;
import org.loom.servlet.LoomServletRequest;
import org.loom.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CaptchaInterceptor
implements ExecuteInterceptor,
FinallyListener {
    @Autowired
    private CaptchaService captchaService;

    public Resolution beforeExecute(ParsedAction action) {
        LoomServletRequest request = action.getRequest();
        String validatedCaptchaID = request.getParameter("_validated-captcha-id");
        HttpSession session = request.getSession(false);
        if (validatedCaptchaID == null || session.getAttribute(validatedCaptchaID) == null) {
            String captcha = request.getParameter("_captcha");
            String message = null;
            if (StringUtils.isEmpty((String)captcha)) {
                message = "captcha.error.missing";
            } else if (session == null || !this.captchaService.validateResponseForID(session.getId(), (Object)captcha).booleanValue()) {
                message = "captcha.error.incorrect";
            }
            if (message != null) {
                action.getMessages().addMessage("_captcha", message);
            } else {
                String validatedID = UUID.randomUUID().toString();
                request.addParameter("_validated-captcha-id", validatedID);
                session.setAttribute(validatedID, (Object)Boolean.TRUE);
            }
        }
        return null;
    }

    public void doFinally(ParsedAction action, Exception e) {
        LoomServletRequest request;
        String validatedID;
        if (e == null && action.getMessages().isEmpty() && (validatedID = (request = action.getRequest()).getParameter("_validated-captcha-id")) != null) {
            HttpSession session = request.getSession(false);
            session.removeAttribute(validatedID);
        }
    }

    public void setCaptchaService(CaptchaService captchaService) {
        this.captchaService = captchaService;
    }
}

