/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.confirmation;

import org.apache.commons.lang.StringUtils;
import org.loom.addons.confirmation.ConfirmationInterceptor;
import org.loom.addons.confirmation.RequiresConfirmation;
import org.loom.annotation.processor.AbstractInjectedInterceptorAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.interceptor.Interceptor;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.Event;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class RequiresConfirmationAnnotationProcessor
extends AbstractInjectedInterceptorAnnotationProcessor<ConfirmationInterceptor> {
    @Autowired
    private MessagesRepositoryFactory messagesRepositoryFactory;

    public RequiresConfirmationAnnotationProcessor() {
        super(ConfirmationInterceptor.class);
    }

    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer methodWrapper : metadata.getAnnotatedMethods(new Class[]{RequiresConfirmation.class})) {
            RequiresConfirmation annotation = (RequiresConfirmation)methodWrapper.getAnnotation(RequiresConfirmation.class);
            Event event = mapping.getEvent(methodWrapper.getName());
            ConfirmationInterceptor interceptor = (ConfirmationInterceptor)this.getInterceptor();
            interceptor.setId(annotation.id());
            interceptor.setType(annotation.type());
            String message = annotation.message();
            if (!StringUtils.isEmpty((String)message)) {
                interceptor.setMessage(message);
            } else {
                message = annotation.id();
            }
            event.addInterceptor((Interceptor)interceptor);
            this.messagesRepositoryFactory.addBrowserMessage(message + ".title");
            this.messagesRepositoryFactory.addBrowserMessage(message + ".message");
            this.messagesRepositoryFactory.addBrowserMessage(message + ".accept");
            this.messagesRepositoryFactory.addBrowserMessage(message + ".cancel");
        }
    }

    public void setMessagesRepositoryFactory(MessagesRepositoryFactory messagesRepositoryFactory) {
        this.messagesRepositoryFactory = messagesRepositoryFactory;
    }
}

