/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.hibernate;

import org.hibernate.validator.Future;
import org.hibernate.validator.Past;
import org.loom.annotation.processor.AbstractAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.mapping.ActionMapping;
import org.loom.validator.PropertyValidator;
import org.loom.validator.ValueParser;
import org.loom.validator.date.DateValidator;
import org.loom.validator.date.DateValue;

public class HibernateDateValidationAnnotationProcessor
extends AbstractAnnotationProcessor {
    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(new Class[]{Past.class, Future.class})) {
            Future future = (Future)property.getAnnotation(Future.class);
            Past past = (Past)property.getAnnotation(Past.class);
            if (future == null && past == null) continue;
            DateValidator validator = new DateValidator();
            if (future != null && past != null) {
                throw new IllegalArgumentException("@Future and @Past specified at the same time for property " + property.getPropertyPath());
            }
            DateValue dateValue = ValueParser.parseDateValue((String)"today");
            if (future != null) {
                validator.setMinValue(dateValue);
                validator.setExcludeMin(true);
            }
            if (past != null) {
                validator.setMaxValue(dateValue);
                validator.setExcludeMax(true);
            }
            validator.setPropertyPath(property.getPropertyPath());
            mapping.addValidator(property.getEventFilter(), (PropertyValidator)validator);
        }
    }
}

