/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.hibernate;

import org.hibernate.validator.Email;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.Pattern;
import org.loom.annotation.processor.AbstractAnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadata;
import org.loom.annotation.processor.metadata.FilteredAnnotationContainer;
import org.loom.mapping.ActionMapping;
import org.loom.validator.PropertyValidator;
import org.loom.validator.StringValidator;

public class HibernateStringValidationAnnotationProcessor
extends AbstractAnnotationProcessor {
    public void process(AnnotationMetadata metadata, ActionMapping mapping) {
        for (FilteredAnnotationContainer property : metadata.getAnnotatedProperties(new Class[]{Pattern.class, Email.class, Length.class, NotEmpty.class})) {
            java.util.regex.Pattern p;
            Pattern pattern = (Pattern)property.getAnnotation(Pattern.class);
            Email email = (Email)property.getAnnotation(Email.class);
            Length length = (Length)property.getAnnotation(Length.class);
            NotEmpty notEmpty = (NotEmpty)property.getAnnotation(NotEmpty.class);
            if (pattern == null && email == null && length == null && notEmpty == null) continue;
            StringValidator validator = new StringValidator();
            if (length != null) {
                if (length.max() != Integer.MAX_VALUE) {
                    validator.setMaxLength(Integer.valueOf(length.max()));
                }
                if (length.min() != 0) {
                    validator.setMinLength(Integer.valueOf(length.min()));
                }
            }
            if (email != null) {
                p = java.util.regex.Pattern.compile("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$");
                validator.setMaskPattern(p);
                validator.setOverridenMessageKey("loom.validation.emailFailed");
            }
            if (pattern != null) {
                p = java.util.regex.Pattern.compile(pattern.regex(), pattern.flags());
                validator.setMaskPattern(p);
            }
            validator.setPropertyPath(property.getPropertyPath());
            mapping.addValidator(property.getEventFilter(), (PropertyValidator)validator);
        }
    }
}

