/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.multiupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.loom.i18n.Message;
import org.loom.interceptor.AbstractPropertyBoundInterceptor;
import org.loom.interceptor.PopulateInterceptor;
import org.loom.interceptor.RetrieveEntityInterceptor;
import org.loom.log.Log;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.ParsedAction;
import org.loom.persistence.file.FileManager;
import org.loom.persistence.file.PersistentFile;
import org.loom.resolution.Resolution;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.params.FileParameterValue;
import org.loom.servlet.params.ParameterValue;
import org.loom.util.RequestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class MultiUploadInterceptor
extends AbstractPropertyBoundInterceptor
implements PopulateInterceptor {
    @Autowired
    private RetrieveEntityInterceptor retrieveEntityInterceptor;
    @Autowired
    private FileManager fileManager;
    private Long maxFileSize;
    private Pattern filenameMaskPattern;
    private static Log log = Log.getLog();

    public Resolution beforePopulate(ParsedAction action) {
        FileParameterValue value;
        String propertyPath = this.getPropertyPath();
        this.retrieveEntityInterceptor.beforePopulate(action);
        LoomServletRequest request = action.getRequest();
        Set<String> existingFileIds = this.getExistingFileIds(request);
        ArrayList<PersistentFile> files = (ArrayList<PersistentFile>)this.getPropertyBinder().getValue((Object)action.getAction(), propertyPath);
        if (files == null) {
            files = new ArrayList<PersistentFile>();
            this.getPropertyBinder().setValue((Object)action.getAction(), files, propertyPath);
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            PersistentFile file = (PersistentFile)i.next();
            String fileId = file.getId().toString();
            if (existingFileIds.contains(fileId)) continue;
            log.trace(new Object[]{"Removing persistent file with id=", fileId, " because it was not included in the current request"});
            i.remove();
        }
        for (ParameterValue v : request.getParameters().getValues()) {
            if (!(v instanceof FileParameterValue) || !v.getName().startsWith(propertyPath)) continue;
            value = (FileParameterValue)v;
            if (this.maxFileSize != null && value.getFileSize() > this.maxFileSize) {
                this.addErrorMessage(action, "loom.validation.fileSizeTooLarge", value);
                value.setAssigned(true);
                continue;
            }
            if (this.filenameMaskPattern == null || this.filenameMaskPattern.matcher(value.getFilename()).matches()) continue;
            this.addErrorMessage(action, "loom.validation.fileNameFailed", value);
            value.setAssigned(true);
        }
        for (ParameterValue v : request.getParameters().getValues()) {
            if (!(v instanceof FileParameterValue) || !v.getName().startsWith(propertyPath)) continue;
            value = (FileParameterValue)v;
            if (!action.hasAnyError()) {
                log.debug(new Object[]{"Saving uploaded file to database ", value.getFilename()});
                PersistentFile uploadedFile = this.createFile(value);
                PersistentFile persistedFile = this.fileManager.merge(uploadedFile);
                files.add(persistedFile);
                log.debug(new Object[]{"File ", value.getFilename(), " saved with id= ", persistedFile.getId()});
            }
            value.setAssigned(true);
        }
        return null;
    }

    private PersistentFile createFile(FileParameterValue value) {
        try {
            PersistentFile file = new PersistentFile();
            file.setFilename(value.getFilename());
            file.setFileSize(value.getFileSize());
            file.setContentType(value.getContentType());
            file.setContentsAsStream(value.getStream());
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addErrorMessage(ParsedAction action, String messageKey, FileParameterValue value) {
        Message message = new Message();
        message.setPropertyPath(value.getName());
        message.setMessageKey(messageKey);
        message.addArg("value", (Object)value);
        message.addArg("interceptor", (Object)this);
        message.addTranslatedArg("propertyName", (Object)this.getPropertyPath());
        action.getMessages().addMessage(message);
    }

    private Set<String> getExistingFileIds(LoomServletRequest request) {
        Map params = RequestUtils.getParametersWithPrefix((LoomServletRequest)request, (String)"_uploaded-");
        HashSet<String> result = new HashSet<String>();
        for (ParameterValue param : params.values()) {
            result.add(param.getString());
        }
        return result;
    }

    public void setPropertyPath(String propertyPath) {
        super.setPropertyPath(propertyPath);
        this.retrieveEntityInterceptor.setPropertyPath(StringUtils.isEmpty((String)propertyPath) ? null : StringUtils.substringBeforeLast((String)propertyPath, (String)"."));
    }

    public void setActionMapping(ActionMapping mapping) {
        super.setActionMapping(mapping);
        this.retrieveEntityInterceptor.setActionMapping(mapping);
    }

    public void setFileManager(FileManager fileController) {
        this.fileManager = fileController;
    }

    public void setRetrieveEntityInterceptor(RetrieveEntityInterceptor retrieveEntityInterceptor) {
        this.retrieveEntityInterceptor = retrieveEntityInterceptor;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setFilenameMaskPattern(Pattern filenameMaskPattern) {
        this.filenameMaskPattern = filenameMaskPattern;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public Pattern getFilenameMaskPattern() {
        return this.filenameMaskPattern;
    }
}

