/*
 * Decompiled with CFR 0.152.
 */
package org.loom.addons.rating;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.servlet.jsp.JspException;
import org.loom.config.ConfigProperties;
import org.loom.i18n.Message;
import org.loom.tags.StringWriterWrapper;
import org.loom.tags.core.InputSelectTag;
import org.loom.tags.core.NumberFieldTag;
import org.loom.tags.core.Option;
import org.loom.tags.core.ValueComparator;

public class InputRatingTag
extends InputSelectTag
implements NumberFieldTag {
    private static final int AVERAGE_SCALE = 1;
    private BigDecimal total;
    private Integer numVotes;
    private BigDecimal max;
    private BigDecimal min;
    private boolean excludeMin = false;
    private boolean excludeMax = true;
    private Integer scale = 1;
    private BigDecimal average;
    private boolean renderRatingText = true;
    private static String CSS = ConfigProperties.getInstance().getProperty("css.RatingTag", "rating");

    public InputRatingTag() {
        this.setCssClass(CSS);
        this.addCssClass("fouc");
        this.setOptionsComparatorClass(ValueComparator.class.getName());
        this.setAddTranslatedName(false);
        this.setEscapeRenderAsText(false);
    }

    public void initTag() {
        super.initTag();
        if (this.total != null && this.numVotes == null) {
            this.setNumVotes(1);
        }
        if (this.max != null) {
            int imax = this.excludeMax ? this.max.intValue() : this.max.intValue() + 1;
            int imin = this.min == null ? 0 : this.min.intValue();
            for (int i = imin = !this.excludeMin ? imin : this.min.intValue() + 1; i <= imax; ++i) {
                this.addOption(new Option((Comparable)Integer.valueOf(i), this.isTranslateLabels() ? this.getName() + '.' + i : String.valueOf(i), this.isTranslateLabels()));
            }
        }
        if (this.total != null && this.numVotes != null && this.numVotes > 0) {
            this.average = this.total.divide(new BigDecimal(this.numVotes), (int)this.scale, RoundingMode.HALF_DOWN);
        }
        this.setExtendedAttribute("average", this.average);
        if (this.scale != 1) {
            this.setExtendedAttribute("scale", this.scale);
        }
    }

    public boolean shouldRenderAsText() {
        return this.getName() == null || super.shouldRenderAsText();
    }

    protected void printParentAttributes() throws IOException, JspException {
        if (this.min != null) {
            int imin = this.min.intValue();
            this.out.printAttribute("min", (Object)(this.excludeMin ? imin + 1 : imin));
        }
        if (this.max != null) {
            int imax = this.max.intValue();
            this.out.printAttribute("max", (Object)(this.excludeMax ? imax : imax + 1));
        }
        super.printParentAttributes();
    }

    public boolean shouldRenderLabel() {
        return this.getName() != null && super.shouldRenderLabel();
    }

    public void doTagImpl() throws JspException, IOException {
        super.doTagImpl();
        this.renderMessage();
    }

    public String renderAsText() {
        try {
            this.out = new StringWriterWrapper();
            this.out.print((CharSequence)"<span class=\"rating-label\">");
            this.out.print((CharSequence)"<span");
            this.printParentAttributes();
            this.out.print((CharSequence)"> </span>");
            this.renderMessage();
            this.out.print((CharSequence)"</span>");
            return ((StringWriterWrapper)this.out).getContents();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JspException e) {
            throw new RuntimeException(e);
        }
    }

    protected void renderMessage() throws IOException {
        if (this.renderRatingText && this.average != null) {
            this.out.print((CharSequence)"<span class=\"message\">");
            Message m = new Message("loom.rating.message").addArg("average", (Object)this.average).addArg("total", (Object)this.total).addArg("numVotes", (Object)this.numVotes);
            this.out.print((CharSequence)this.getMessagesRepository().translateMessage(m));
            this.out.print((CharSequence)"</span>");
        }
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public void setNumVotes(Integer numVotes) {
        this.numVotes = numVotes;
        this.setExtendedAttribute("numVotes", numVotes);
    }

    public void setRenderRatingText(boolean renderText) {
        this.renderRatingText = renderText;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public Integer getNumVotes() {
        return this.numVotes;
    }

    public boolean isRenderRatingText() {
        return this.renderRatingText;
    }

    public BigDecimal getAverage() {
        return this.average;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public void setMaxValue(double max) {
        this.max = new BigDecimal(String.valueOf(max));
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public void setMinValue(double min) {
        this.min = new BigDecimal(String.valueOf(min));
    }

    public void setExcludeMax(boolean excludeMax) {
        this.excludeMax = excludeMax;
    }

    public void setExcludeMin(boolean excludeMin) {
        this.excludeMin = excludeMin;
    }

    public void setPrecision(Integer precision) {
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public boolean isExcludeMin() {
        return this.excludeMin;
    }

    public boolean isExcludeMax() {
        return this.excludeMax;
    }
}

