/**
 * Replace select field with a rating component.
 * The slect will be updated to the rated value.
 *
 * @author icoloma
 * Requires: core, ui
 */
loom.ui.Rating = Class.create({
	
    initialize: function(element, options) {
	
        // IE 6 is not supported
        if (loom.ie6) {
            return;
        }
        
        this.options = Object.extend({
        	width: 85,  			// width of the component, in pixels
        	height: 17, 			// height of the component, in pixels
        	voteOnce: true, 		// true to disable after voting
        	submitOnVote: false, 	// true to submit the containing form automatically
        	starImage: loom.getScriptPath('rating.js') + 'star.png',	// the image to use for the stars
        	bgColor: '#ccc', 		// the color of the rating background
        	barColor: '#ef6900' 	// the color of the current value
        }, options || {});
        
        
        element = $(element);
        if (element.tagName == 'SELECT') {
	        this.select = element;
            this.selectOptions = this.select.select('option');
            this.max = this.selectOptions.length - 1;
            var selected = this.select.select('option[selected]').first();
            this.average = selected && parseInt(selected.value);
        } 
        element.hide();
        this.max = this.max || element.getAttribute('max');
        if (!this.max) {
            throw new Error('Cannot calculate the rating max: Missing "max" attribute, option or <select> tag');
        }
        
        // the maximum value, 0-based
        this.max = parseFloat(this.max);
        
        // add nested divs 
        this.container = element.insert({ 
        	after: '<span class="rating-container"><span class="bg"></span><span class="bar"></span><span class="stars"></span>'
        }).next();
        $w("container bg bar stars").each(function(e) {
            var element = this[e] = e == 'container'? this.container : this.container.down('.' + e);
            element.setStyle({
            	'float': 'left',
            	padding: 0,
            	margin: [ 'bar', 'stars'].indexOf(e) == -1? '0' : '0 0 0 -#{width}px'.interpolate(this.options),
            	width: this.options.width + 'px',
            	height: this.options.height + 'px',
            	overflow: "hidden",
            	backgroundColor: this.options[e + 'Color'] //|| 'none'
            });
        }.bind(this)); 
        this.stars.setStyle({ background: 'url(#{starImage}) top left repeat-x'.interpolate(this.options) });
        this.message = element.next('.message');
        
        // set the current value
        this.numVotes = parseInt(element.getExtendedAttribute('numVotes')) || 0;
        this.average = this.average || element.getExtendedAttribute('average') || 0;
        this.scale = element.getExtendedAttribute('scale') || 1;
        this.setValue(this.average);
        this.setDefaultMessage();
        
        // listen for mouse events
        $A(['onMouseMove', 'onMouseOver', 'onMouseOut', 'onClick']).each(function(f) {
            var event = f.substring(2).toLowerCase();
            this[f] = this[f].bindAsEventListener(this);
            this.stars.observe(event, this[f]);
        }.bind(this));
        (this.select == null || this.select.disabled) && this.disable();
    },
    
    /** disable the rating component */
    disable:  function() {
        this.disabled = true;
        this.bar.addClassName('disabled');
        this.stars.stopObserving();
    },
    
    /** 
      set a vote 
      @param vote a floating point value between 0 and max
     */
    setValue: function(v) {
        v = parseFloat(v);
        this.bar.setStyle({
            width: (v * this.options.width) / this.max + "px"
        });
        this.value = v;
        
        // set the message to the corresponding select option
        if (this.message && this.selectOptions)
            this.message.innerHTML = this.selectOptions[Math.round(v)].innerHTML;
    },
    
    /** set the message to the default */
    setDefaultMessage: function() {
        if (this.message)
            this.message.innerHTML = loom.messages['loom.rating.message'].interpolate(this, /(^|.|\r|\n)(\$\{(.*?)\})/);
    },
    
    onMouseMove: function(e) {
        var width = e.pointerX() - this.bg.cumulativeOffset().left;
        width = width > 0? width < this.options.width? width : this.options.width : 0;
        this.setValue(Math.round(width * this.max / this.options.width));
    },
    
    onMouseOver: function(e) {
        this.bar.addClassName('selected');
    },
    
    onMouseOut: function(e) {
        this.setValue(this.average);
        this.setDefaultMessage();
        this.bar.removeClassName('selected');
    },
    
    onClick: function(e) {
        this.select.selectedIndex = Math.round(this.value);
        this.average = this.round((this.average * this.numVotes + parseInt(this.select.getValue())) / (this.numVotes + 1));
        this.setValue(this.average);
        this.numVotes++;
        this.setDefaultMessage();
        this.options.voteOnce && this.disable();
        this.options.submitOnVote && e.target.up('form').submit();
    },
    
    /** leave only this.scale decimal places in a number */
    round: function(number) {
        var p = Math.pow(10, this.scale);
        return (number * p).round() / p;
    }
});
