/*
 * Modified version of the Fabtabulous library.
 * Loom: Added onActivate event listener 
 * Loom: Added default options 
 *
 * Modification: added support to set css classes on li containers instead of links
 * Modification: parameterized the activeClass name.
 * Original license follows.
 * =================================================
 * Fabtabulous! Simple tabs using Prototype
 * http://tetlaw.id.au/view/blog/fabtabulous-simple-tabs-using-prototype/
 * Andrew Tetlaw
 * version 1.1 2006-05-06
 * http://creativecommons.org/licenses/by-sa/2.5/
 */
var Fabtabs = Class.create();

Fabtabs.anchorRegex = /#(\w.+)/;		

Fabtabs.defaultOptions = {
	activeClass: 'active',
	
	// the event listener when a tab gets activated. 
	// The argument is the activated tab
	onActivate: null
};

Fabtabs.prototype = {

	initialize : function(element) {
		this.element = $(element);
		var options = Object.extend(Fabtabs.defaultOptions, arguments[1] || {});
		Object.extend(this, options);

		this.menu = $A(this.element.getElementsByTagName('a'));
		var initTab = this.getInitialTab();
		this.show(initTab);
		this.menu.without(initTab).each(this.hide.bind(this));
		this.menu.each(this.setupTab.bind(this));
	},
	setupTab : function(elm) {
		Event.observe(elm,'click',this.activate.bindAsEventListener(this),false)
	},
	activate :  function(ev) {
		var elm = ev.target;
		ev.stop();
		this.show(elm);
		this.menu.without(elm).each(this.hide.bind(this));
	},
	hide : function(elm) {
		$(elm).up('li').removeClassName(this.activeClass);
		$(this.tabID(elm)).hide();
	},
	show : function(elm) {
		$(elm).up('li').addClassName(this.activeClass);
		$(this.tabID(elm)).show();
		if (this.onActivate) {
			this.onActivate($(this.tabID(elm)));
		}
	},
	tabID : function(elm) {
		return elm.href.match(Fabtabs.anchorRegex)[1];
	},
	getInitialTab : function() {
		if(document.location.href.match(Fabtabs.anchorRegex)) {
			var loc = RegExp.$1;
			var elm = this.menu.find(function(value) { 
				return value.href.match(Fabtabs.anchorRegex)[1] == loc; 
			});
			return elm || this.menu.first();
		} else {
			return this.menu.first();
		}
	}
}

