/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * Fallback if there is no Firebug installed
 * For details on logging, see:
 * http://www.getfirebug.com/logging.html
 * http://www.getfirebug.com/console.html
 */
if (!console) {
    var console = {
        log: Prototype.emptyFunction,
        debug: Prototype.emptyFunction,
        info: Prototype.emptyFunction,
        warn: Prototype.emptyFunction,
        error: Prototype.emptyFunction,
        assert: Prototype.emptyFunction,
        dir: Prototype.emptyFunction,
        dirxml: Prototype.emptyFunction,
        group: Prototype.emptyFunction,
        groupEnd: Prototype.emptyFunction,
        time: Prototype.emptyFunction,
        timeEnd: Prototype.emptyFunction,
        profile: Prototype.emptyFunction,
        profileEnd: Prototype.emptyFunction,
        count: Prototype.emptyFunction
    }
}

if (!Prototype || Prototype.Version < '1.6') {
    console.error('This version of Loom requires Prototype 1.6.0 or greater');
}


/** keycodes that are not text */
Event.SPECIAL_KEYS = [ 
    Event.KEY_BACKSPACE, Event.KEY_TAB, Event.KEY_RETURN, Event.KEY_ESC, Event.KEY_LEFT, 
    Event.KEY_UP, Event.KEY_RIGHT, Event.KEY_DOWN, Event.KEY_DELETE, Event.KEY_HOME, 
    Event.KEY_END, Event.KEY_PAGEUP, Event.KEY_PAGEDOWN
    ];

/**
 * Common functionality
 */
var Commons = {

  // property values that cannot be appended to css classes (too long or not CDATA compliant)
  // to use: Commons.indexedPropertyValues[myComponentName] = { property: value };
  extendedProperties: { },

  // regular expression for css properties
  cssPropertiesRegEx: /_options-(\w+)-([^ \t\n]+)/,
  
  // Extract attributes from CSS values and add them to the element passed.
  // will convert any "_options-name-value" to JSON properties.  
  extractCssProperties: function(element) {
     element.className.scan(Commons.cssPropertiesRegEx, function(clazz) { 
        var parts = clazz[0].match(Commons.cssPropertiesRegEx);
     	element[parts[1]] = parts[2]; 
     });
     if (element.id && Commons.extendedProperties[element.id]) {
     	Object.extend(element, Commons.extendedProperties[element.id]); 
     }
     
  },
  
   // if there is already a hidden input field with this name, change its value
   // else add the field. Returns the old value of this field, if any 
   setOrReplaceHidden: function(form, name, value) {
   	var field = form[name];
   	var oldValue = null;
	if (field) {
		oldValue = field.value;
		field.value = value;
	} else {
		form.insert('<input type="hidden" name="' + name + '" value="' + value + '"/>');
	}
	return oldValue;
   },
   
   // search the next valid index for a multiple field of the form prefix[index]
   // template: the template to search in the form 'my.nested.PropertyName[${index}]'
   // return the next available field name
   getNextAvailableFieldName: function(form, template) {
   	  for (var i = 0; i < 100; i++) {
   	     var candidate = template.interpolate({ index: i }, Errors.ParameterPattern);
   	     if (!$(candidate)) {
   	       return candidate;
   	     }
   	  }
   	  throw new Error('Could not find next field name (max iterations reached).');
   }
}

var Selection = {
	
	// this part is based on work by Diego Perini <dperini@nwbox.com>
	// original work can be visited at http://javascript.nwbox.com/cursor_position/
	// adapted to use prototype 

	setRange: function(input, start, end) {
		if (input.setSelectionRange) {
			input.setSelectionRange(start, end);
		} else {
			// assumed IE
			var range = input.createTextRange();
			range.collapse(true);
			range.moveStart("character", start);
			range.moveEnd("character", end - start);
			range.select();
		}
	},
	
	getStart: function(input) {
		if (input.createTextRange) {
			var range = document.selection.createRange().duplicate();
			range.moveEnd('character', input.value.length);
			return range.text == ''? input.value.length : input.value.lastIndexOf(range.text);
		} else {
			return input.selectionStart;
		}
	},
	
	getEnd: function(input) {
		if (input.createTextRange) {
			var range = document.selection.createRange().duplicate();
			range.moveStart('character', -o.value.length)
			return range.text.length;
		} else { 
			return input.selectionEnd;
		}
	}
	
}

// Remove the fouc css class once the file has been loaded
// TODO: do this in a more efficient manner by removing the display attribute 
// of the CSS style instead of using this selector
document.observe("dom:loaded", function() {
  $$('.hide-fouc').invoke('removeClassName', 'hide-fouc');
  $$('.extended').each(function(element) {
     Commons.extractCssProperties(element);
  });
});

