/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * A simple example of a list menu behavior.
 * Note that because of accessibility, all menu items will be expanded by default 
 * and use javascript to un-expand them, leaving only the selected one expanded.
 *
 * @author rgrocha 
 * @author icoloma 
 */
document.observe("dom:loaded", function() {

	$$('ul.menu li.submenu a').invoke('observe', 'click', function(event) {
		var a = event.target;
		var li = a.parentNode;
		li.toggleClassName('expanded');
		if (a.href.startsWith('#')) {
			event.stop();
		}
	});
	$$('ul.menu li.expanded').each(function(element) {
		// un-expand any item that is not current item or its child 		
		if (!element.hasClassName('selected') && !element.down('li.selected')) {
			element.removeClassName('expanded');
		}
	});
	
});