/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * Multiple file upload.
 * For details about how multiple file uploading is implemented, check 
 * UploadedFilesInterceptor.java
 * 
 * @author icoloma
 */
var MultipleUpload = {

    /** adds a new input file to the form when the "add new" button is clicked */
    addInputFile: function(div) {
        var ul = div.down('ul');
        if (!ul) {
        	div.insert(new Element('ul'));
        	ul = div.down('ul');
        }
        
        // create a new li
        ul.insert('<li><input type="file" name="#{name}"/><a href="#" class="removeFile">#{removeFile}</a></li>\n'.interpolate({
        	 name: MultipleUpload.getNextInputFileName(div.id),
        	 removeFile: Resources.jsRemoveFile
        }));
        ul.select('li:last-child a.removeFile').first().observe('click', MultipleUpload.removeInputFile);
    },
	
	/** Removes a file */
    removeInputFile: function(event) {
        event.target.up("li").remove();
        event.stop();
    },
    
    /** return the next input file name */
    getNextInputFileName: function(name) {
    	for (var i = 0; i < 100; i++) {
    	  var candidate = name + '[' + i + ']';
    	  var search1 = 'input[name="#{candidate}"]'.interpolate( { candidate: candidate });
    	  var search2 = 'input[name="loom-uploaded-#{candidate}"]'.interpolate( { candidate: candidate });
   	     
   	     if ($$([search1, search2]).length == 0) {
   	       return candidate;
   	     }
   	  }
   	  throw new Error('Could not find next field name (max iterations reached).');
    }
};

document.observe("dom:loaded", function() {
    $$('a.addfile').invoke('observe', 'click', function(event) { MultipleUpload.addInputFile(event.target.previous('div')); event.stop(); });
});
 
