/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * This file creates the slider under any textarea with css class "resizable"
 * @author rgrocha at extrema-sistemas.com
 */
var ResizableTextarea = {
	apply : function(textarea) {

		new Insertion.Before(textarea, '<div class="resizable"><span></span><div class="grippie"></div></div>');
		var container = textarea.up().getElementsBySelector('div.resizable')[0];
		container.getElementsBySelector('span')[0].appendChild(textarea);

		var grippie = container.getElementsBySelector('div.grippie')[0];
		//grippie.style.marginRight = (grippie.offsetWidth - textarea.offsetWidth) +'px';

		container.staticOffset = null;
		container.textarea = $(textarea);
		container.grippie = $(grippie);

		container.startDrag = ResizableTextarea.startDrag.bindAsEventListener(container);
		container.performDrag = ResizableTextarea.performDrag.bindAsEventListener(container);
		container.endDrag = ResizableTextarea.endDrag.bindAsEventListener(container);

		grippie.observe('mousedown', container.startDrag);
	},

	startDrag : function (e) {
		this.staticOffset = this.textarea.getHeight() - Event.pointerY(e);
		this.textarea.setStyle({opacity : 0.25});

		Event.observe(document, 'mousemove', this.performDrag);
		Event.observe(document, 'mouseup', this.endDrag);

		return false;
	},

	performDrag : function (e) {
		this.textarea.setStyle({'height' : Math.max(32, this.staticOffset + Event.pointerY(e)) + 'px'});

		return false;
	},

	endDrag : function (e) {
		Event.stopObserving(document, 'mousemove', this.performDrag);
		Event.stopObserving(document, 'mouseup', this.endDrag);
		this.textarea.setStyle({opacity : 1});
	}
    
};

document.observe("dom:loaded", function() {
    $$('textarea.resizable').each(ResizableTextarea.apply);
});

