/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * Confirmation before navigating to a url.
 * This script asks the user for confirmation before really following a url.
 * To use, just annotate the corresponding event with @RequiresConfirmation.
 * Note that this feature should work even with javascript turned off.
 * @author icoloma
 */
var Confirmation = {

	// ask for link confirmation
	onclick: function(event) {
	  event.stop();
	  var a = event.findElement('a');
	  var html = Confirmation.createWindow(a.message, a.href + (a.href.include('?') ? '&' : '?') + "loom-confirmation-" + a.confirmationId + "=true");
	},
	
	// ask for form confirmation
	onbuttonclick: function(event) {
	  var button = event.findElement('input');
	  var confId = "loom-confirmation-" + button.confirmationId;
	  var form = button.up('form');
	  event.stop();
	  var message = button.message;
	  Confirmation.createWindow(message, "#", function() { 
		  $$('div.confirmationButtonBar a.accept').invoke('observe', 'click', function(e) {
		    e.stop();
		    Confirmation.hideModal();
		    Commons.setOrReplaceHidden(form, confId, "true");
		    if (button.name.startsWith('loom-event-')) {
		    	var oldValue = Commons.setOrReplaceHidden(form, 'event', button.name.gsub('loom-event-', ''));
			  	form.submit();
			  	if (oldValue) {
				  	form['event'].value = oldValue;
			  	} else {
				  	form['event'].remove();
			  	}
		    } else {
			  	form.submit();
		    }
		  });
	  });
	},
	
	createWindow: function(message, targetUrl, afterLoad) {
	  var html = ('<div class="jsconfirmation">#{message}' +
		'<div class="confirmationButtonBar"><a href="#{targetUrl}" class="accept">#{accept}</a><a href="#" class="cancel" onclick="Confirmation.hideModal(); return false">#{cancel}</a>' +
		'</div></div>').interpolate({
		  message: Resources[message + '.message'],
		  accept: Resources[message + '.accept'],
		  cancel: Resources[message + '.cancel'],
		  targetUrl: targetUrl
	  });
	  Modalbox.show(html, { title: Resources[message + '.title'], afterLoad: afterLoad });
	},
	
	hideModal: function(htmlText, options) {
	  Modalbox.hide();
	}
	
}

document.observe("dom:loaded", function() {
	$$('a.confirmation').invoke('observe', 'click', Confirmation.onclick);
	$$('input.confirmation[type="submit"]').invoke('observe', 'click', Confirmation.onbuttonclick);
	$(document.body).insert('<div id="confirmationBuffer" style="display:none"></div>');
});

