/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * Multiple checkbox handling routines.
 * This class binds a set of checkboxes with a global "select/unselect all" 
 * checkbox.
 *
 * To use, new MultiCheckbox(table);
 * 
 * This class will put an extra checkBox (a "switch") on the header cell of the first column
 * where checkboxes are detected. This switch will check and uncheck all checkboxes at once. 
 *
 * @author icoloma
 */
var MultiCheckbox = Class.create({

   initialize: function(table, options) {
     this.checkboxes = table.select('input[type="checkbox"]');
     options = Object.extend({
        // the position of the global switch column, starting at 0. If not set, 
        // the first column with a checkbox will be used. In that case, if none is found
        // (ex. the table is empty) nothing will be initialized.
     	switchColumn: -1
     }, options);
     this.options = options;
     
     var column = options.switchColumn;
     if (column == -1 && this.checkboxes.size() > 0) {
       // locate the corresponding th
       var checkbox = this.checkboxes.first();
       var cells = checkbox.up('tr').select('td'); 
       column = cells.indexOf(checkbox.up('td'));
     }
     
     if (column != -1) {
     	var th = table.select('th')[column];
     	 th.update('<input type="checkbox" class="checkbox"/>');
     	 this.gswitch = th.down('input');
	     this.gswitch.observe('click', this.onSwitchClick.bindAsEventListener(this));
	     this.checkboxes.invoke('observe', 'click', this.onClick.bindAsEventListener(this));
     }
   },
   
   // fired when a managed checkbox is clicked
   onClick: function(event) {
     if (event.target.checked) {
     	this.gswitch.checked = this.checkboxes.all(function(element) { return element.checked; });
     } else {
     	this.gswitch.checked = false;
   	 }
   },
   
   onSwitchClick: function(event) {
     this.checkboxes.each(function(element) { element.checked = event.target.checked } );
   },
   
   // adds a checkbox to this handler
   addCheckbox: function(element) {
     this.checkboxes.push(element);
     element.observe('click', this.onClick.bindAsEventListener(this));
   }
   
});

 
