/*  
 * The Loom framework
 * (c) Extrema Sistemas de Informacion
 *
 * Distributed under the Apache License, Version 2.0
 */

/**
 * Expand clickable tables to make the whole row behave as the first link in the row. 
 *
 * @author rgrocha 
 * @author icoloma 
 */
var Tables = {

	// process table so that each row is clickable and points to the same location as the first
	// link found in the row
	processDataTable: function(table) {
        var rows = (table.tBodies[0] || table).getElementsByTagName("tr");
        // add event handlers so rows are clickable
        if (rows) {
        	$A(rows).each(function(row) {
                row = $(row);
        		var links = row.getElementsByTagName('a');
        		if (links.length > 0) {
        			row.addClassName('dataTable-link');
                    row.observe('click', function(event) {
					    // skip the jump if the event comes from a link or a form element (input or select).
					    var tagName = event.target.tagName;
					    if (tagName == 'INPUT' || tagName == 'SELECT' || tagName == 'A') { 
					    	return;
				    	}
					    location.href = links[0].href;
					    event.stop();
                    });
                    
        		}
        	});
        }
	}

};

document.observe("dom:loaded", function() {
	$$('table.dataTable').each(Tables.processDataTable);
});

