/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import java.util.HashMap;
import java.util.Map;

import org.loom.config.Config;
import org.loom.injection.DependencyInjectionAdapter;

public class MockDependencyInjectionAdapter implements DependencyInjectionAdapter {

	private Map<String, Object> beans = new HashMap<String, Object>();
	
	public Object getBean(String beanName) {
		return beans.get(beanName);
	}
	
	public void setBean(String name, Object value) {
		beans.put(name, value);
	}

	public <T> T getFirstBeanOfType(Class<T> clazz) {
		Map<String, T> m = getBeansOfType(clazz);
		return m.isEmpty()? null : m.entrySet().iterator().next().getValue();
	}
	
	@SuppressWarnings("unchecked")
	public <T> Map<String, T> getBeansOfType(Class<T> clazz) {
		Map<String, T> result = new HashMap<String, T>();
		for (Map.Entry<String, Object> entry : beans.entrySet()) {
			if (clazz.isAssignableFrom(entry.getValue().getClass())) {
				result.put(entry.getKey(), (T) entry.getValue());
			}
		}
		return result;
	}

	public String getProviderName() {
		return "Mock DI Provider";
	}

	public Config getConfig() {
		return null;
	}

	public boolean containsBean(String beanName) {
		return beans.containsKey(beanName);
	}

}
