/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

import org.loom.tags.LoomTag;

public class MockElExpressionFactory extends ExpressionFactory {

	private LoomTag tag;
	
	public MockElExpressionFactory(LoomTag tag) {
		this.tag = tag;
	}

	@Override
	public Object coerceToType(Object obj, Class<?> targetType) {
		return null;
	}

	@Override
	public MethodExpression createMethodExpression(ELContext context, String expression,
			Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
		return null;
	}

	@Override
	public ValueExpression createValueExpression(Object instance, Class<?> expectedType) {
		return null;
	}

	@Override
	public ValueExpression createValueExpression(ELContext context, String expression,
			Class<?> expectedType) {
		return new MockValueExpression(expression);
	}

	private class MockValueExpression extends ValueExpression {

		private String expression;
		
		public MockValueExpression(String expression) {
			this.expression = expression;
		}

		@Override
		public Class<?> getExpectedType() {
			return null;
		}

		@Override
		public Class<?> getType(ELContext context) {
			return null;
		}

		/**
		 * Quick and dirty implementation of an EL engine
		 */
		@Override
		public Object getValue(ELContext context) {
				
			StringBuilder builder = new StringBuilder();
			int pos = 0;
			do {
				int init = expression.indexOf("${", pos);
				if (init == -1) {
					break;
				}
				int end = expression.indexOf("}", init);
				if (end == -1) {
					break;
				}
				builder.append(expression, pos, init);
				builder.append(tag.getScopedAttribute(expression.substring(init + 2, end), null));
				pos = end + 1;
			} while (true);
			
			builder.append(expression, pos, expression.length());
			return builder.toString();
				
		}

		@Override
		public boolean isReadOnly(ELContext context) {
			return false;
		}

		@Override
		public void setValue(ELContext context, Object value) {
		}

		@Override
		public boolean equals(Object obj) {
			return false;
		}

		@Override
		public String getExpressionString() {
			return null;
		}

		@Override
		public int hashCode() {
			return 0;
		}

		@Override
		public boolean isLiteralText() {
			return false;
		}
		
	}
	
}
