/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import java.util.List;

import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;

import org.loom.paged.PagedListCriteria;
import org.loom.paged.PagedListData;
import org.loom.persistence.ExtendedEntityManager;

/**
 * An empty implementation of EntityManager
 * @author icoloma
 *
 */
public class MockEntityManager implements ExtendedEntityManager {

	public void clear() {
	}

	public void close() {
	}

	public boolean contains(Object entity) {
		return false;
	}

	public Query createNamedQuery(String name) {
		return null;
	}

	public Query createNativeQuery(String sqlString) {
		return null;
	}

	@SuppressWarnings("unchecked")
	public Query createNativeQuery(String sqlString, Class resultClass) {
		return null;
	}

	public Query createNativeQuery(String sqlString, String resultSetMapping) {
		return null;
	}

	public Query createQuery(String qlString) {
		return null;
	}

	public <T> T find(Class<T> entityClass, Object primaryKey) {
		return null;
	}

	public void flush() {
	}

	public Object getDelegate() {
		return null;
	}

	public FlushModeType getFlushMode() {
		return null;
	}

	public <T> T getReference(Class<T> entityClass, Object primaryKey) {
		return null;
	}

	public EntityTransaction getTransaction() {
		return null;
	}

	public boolean isOpen() {
		return false;
	}

	public void joinTransaction() {
	}

	public void lock(Object entity, LockModeType lockMode) {
	}

	public <T> T merge(T entity) {
		return null;
	}

	public void persist(Object entity) {
	}

	public void refresh(Object entity) {
	}

	public void remove(Object entity) {
	}

	public void setFlushMode(FlushModeType flushMode) {
	}

	public void evict(Object entity) {
	}

	public <T> List<T> find(String queryString, Object... params) {
		return null;
	}

	public <T> List<T> findAll(Class<T> clazz) {
		return null;
	}

	public <T> List<T> findNamed(String namedQuery, Object... params) {
		return null;
	}

	public <T> T findNamedSingle(String namedQuery, Object... params) {
		return null;
	}

	public <T> T findSingle(String queryString, Object... params) {
		return null;
	}

	public String getIdPropertyName(Class<?> clazz) {
		// the most common case in tests
		return "id";
	}

	public String getVersionPropertyName(Class<?> clazz) {
		return null;
	}

	public <T> T getVersionValue(Object entity) {
		return null;
	}

	public <T> PagedListData<T> query(PagedListCriteria criteria) {
		return null;
	}

	public <T> T remove(Class<T> clazz, Object id) {
		return null;
	}

	public void setReadOnly(Object entity, boolean readOnly) {
	}

	public int update(String queryString, Object... params) {
		return 0;
	}



}
