/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import org.apache.commons.fileupload.FileItem;

public class MockFileItem implements FileItem {

	private String name;
	
	private InputStream inputStream = new ByteArrayInputStream("hello world".getBytes());
	
	private long size = "hello world".length();
	
	private String contentType;
	
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public MockFileItem(String name) {
		this.name = name;
	}

	public void delete() {
	}

	public byte[] get() {
		return null;
	}

	public String getContentType() {
		return contentType;
	}

	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public String getFieldName() {
		return name;
	}

	public InputStream getInputStream() throws IOException {
		return inputStream;
	}

	public String getName() {
		return name;
	}

	public OutputStream getOutputStream() throws IOException {
		return null;
	}

	public long getSize() {
		return size;
	}

	public String getString() {
		return null;
	}

	public String getString(String encoding) throws UnsupportedEncodingException {
		return null;
	}

	public boolean isFormField() {
		return false;
	}

	public boolean isInMemory() {
		return false;
	}

	public void setFieldName(String name) {
	}

	public void setFormField(boolean state) {
	}

	public void write(File file) throws Exception {
	}

	public void setSize(long size) {
		this.size = size;
	}
	
}