/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import org.loom.persistence.file.FileManager;
import org.loom.persistence.file.PersistentFile;

public class MockFileManager implements FileManager {

	private int count;
	
	public PersistentFile find(Integer id) {
		PersistentFile result = new PersistentFile();
		result.setId((Integer) id);
		return result;
	}

	public PersistentFile merge(PersistentFile file) {
		PersistentFile result = new PersistentFile();
		result.setId(count++);
		result.setFilename(file.getFilename());
		result.setFileSize(file.getFileSize());
		result.setContentType(file.getContentType());
		return result;
	}

	public PersistentFile remove(Integer id) {
		return null;
	}

	
}
