/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import java.io.IOException;
import java.io.InputStream;

import org.loom.servlet.params.AbstractParameterValue;
import org.loom.servlet.params.FileParameterValue;

public class MockFileParamValue extends AbstractParameterValue implements FileParameterValue {

	public MockFileParamValue(String name) {
		super(name);
	}

	public String getContentType() {
		return "text/html";
	}

	public Long getFileSize() {
		return 1000L;
	}

	public String getFilename() {
		return "filename(" + getName() + ").txt";
	}

	public byte[] getBytes() {
		return null;
	}

	public InputStream getStream() throws IOException {
		return null;
	}

	public String getString() {
		return null;
	}

	public void setContentType(String contentType) {
	}

}
