/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.jsp.JspApplicationContext;

import org.loom.tags.LoomTag;

class MockJspApplicationContext implements JspApplicationContext {

	private ExpressionFactory expressionFactory;
	
	public MockJspApplicationContext(LoomTag tag) {
		expressionFactory = new MockElExpressionFactory(tag);
	}
	
	public void addELContextListener(ELContextListener listener) {
		throw new UnsupportedOperationException("Not implemented");
	}

	public void addELResolver(ELResolver resolver) {
		throw new UnsupportedOperationException("Not implemented");
	}

	public ExpressionFactory getExpressionFactory() {
		return expressionFactory;
	}

}
