/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;

import org.loom.tags.LoomTag;

public class MockJspFactory extends JspFactory {

	private JspApplicationContext applicationContext;
	
	public MockJspFactory(LoomTag tag) {
		this.applicationContext = new MockJspApplicationContext(tag);
	}

	@Override
	public JspEngineInfo getEngineInfo() {
		throw new UnsupportedOperationException("Not implemented");
	}

	@Override
	public JspApplicationContext getJspApplicationContext(ServletContext context) {
		return applicationContext;
	}

	@Override
	public PageContext getPageContext(Servlet servlet, ServletRequest request,
			ServletResponse response, String errorPageURL, boolean needsSession, int buffer,
			boolean autoflush) {
		throw new UnsupportedOperationException("Not implemented");
	}

	@Override
	public void releasePageContext(PageContext pc) {
	}

}
