package org.loom.mock;

import java.io.IOException;
import java.io.Writer;
import java.util.List;

import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;

import org.loom.tags.AbstractTag;

import com.google.common.collect.Lists;

/**
 * This class can be assigned to any Loom tag to be executed when doBody() gets invoked
 * @author icoloma
 *
 */
public class MockJspFragment extends JspFragment {

	/** the JspContext to use */
	private JspContext jspContext;
	
	/** the list of nested tags to execute, if any */
	private List<AbstractTag> tags = Lists.newArrayList();
	
	/** the text to print, if any */
	private String bodyContent;
	
	public MockJspFragment(JspContext jspContext) {
		this.jspContext = jspContext;
	}

	@Override
	public JspContext getJspContext() {
		return jspContext;
	}

	@Override
	public void invoke(Writer out) throws JspException, IOException {
		for (AbstractTag tag : tags) {
			tag.setJspContext(jspContext);
			tag.doTag();
		}
		if (bodyContent !=  null) {
			out.append(bodyContent);
		}
	}
	
	public void addTag(AbstractTag tag) {
		tags.add(tag);
	}

	public void setBodyContent(String bodyContent) {
		this.bodyContent = bodyContent;
	}

}
