/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import java.io.IOException;
import java.io.StringWriter;

import javax.servlet.jsp.JspWriter;

public class MockJspWriter extends JspWriter {
	
	private StringWriter writer = new StringWriter();

	protected MockJspWriter() {
		super(1000, false);
	}

	/**
	 * Will use this method to flush to the standard console the output 
	 */
	public void flush() throws IOException {
		writer.flush();
		System.out.println(writer.getBuffer().toString());
	}
	
	/**
	 * Convenience method
	 */
	public String toString() {
		return writer.getBuffer().toString();
	}
	
	@Override
	public void clear() throws IOException {
		writer = new StringWriter();
	}

	@Override
	public void clearBuffer() throws IOException {
		writer = new StringWriter();
	}

	@Override
	public void close() throws IOException {
		writer.close();
	}

	@Override
	public int getRemaining() {
		return 1024 * 1024 * 1024 - writer.getBuffer().length();
	}

	@Override
	public void newLine() throws IOException {
		writer.append('\n');
	}

	@Override
	public void print(boolean b) throws IOException {
		writer.append(Boolean.toString(b));
	}

	@Override
	public void print(char c) throws IOException {
		writer.append(c);
	}

	@Override
	public void print(int i) throws IOException {
		writer.append(Integer.toString(i));
	}

	@Override
	public void print(long l) throws IOException {
		writer.append(Long.toString(l));
	}

	@Override
	public void print(float f) throws IOException {
		writer.append(Float.toString(f));
	}

	@Override
	public void print(double d) throws IOException {
		writer.append(Double.toString(d));
	}

	@Override
	public void print(char[] s) throws IOException {
		writer.write(s);
	}

	@Override
	public void print(String s) throws IOException {
		writer.write(s);
	}

	@Override
	public void print(Object obj) throws IOException {
		writer.write(obj == null? "null" : obj.toString());
	}

	@Override
	public void println() throws IOException {
		writer.append('\n');
	}

	@Override
	public void println(boolean x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(char x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(int x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(long x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(float x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(double x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(char[] x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(String x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void println(Object x) throws IOException {
		print(x);
		println();
	}

	@Override
	public void write(char[] cbuf, int off, int len) throws IOException {
		writer.write(cbuf, off, len);
	}

	public StringWriter getWriter() {
		return writer;
	}

	public void setWriter(StringWriter writer) {
		this.writer = writer;
	}

}
