/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import javax.el.ELContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;



public class MockPageContext extends org.springframework.mock.web.MockPageContext {

	private MockJspWriter writer = new MockJspWriter();
	
	private ELContext elcontext;
	
	public MockPageContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
		super(servletContext, request, response);
		elcontext = new MockElContext();
	}

	@Override
	public JspWriter getOut() {
		return writer;
	}
	
	@Override
	public ELContext getELContext() {
		return elcontext;
	}
	
}
