/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import java.io.ByteArrayInputStream;

import org.loom.persistence.file.PersistentFile;

/**
 * Factory used to create test PersistentFile instances
 * @author icoloma
 */
public abstract class MockPersistentFileFactory extends PersistentFile {

	public static final byte[] FILE_CONTENTS = "test contents".getBytes();
	
	public static PersistentFile createMockFile() {
		PersistentFile file = new PersistentFile();
		file.setFilename("mock-file.txt");
		file.setContentType("text/plain");
		file.setFileSize((long)FILE_CONTENTS.length);
		file.setContentsAsStream(new ByteArrayInputStream(FILE_CONTENTS));
		return file;
	}
	
	
}
