/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.mock;

import org.loom.action.Action;
import org.loom.persistence.file.PersistentFile;
import org.loom.resolution.ForwardResolution;
import org.loom.resolution.PersistentFileResolution;
import org.loom.resolution.RedirectResolution;
import org.loom.resolution.ResolutionFactory;
import org.loom.url.UrlBuilder;

/**
 * Mock ResolutionFactory implementation for testing ActionBeans
 * @author icoloma
 *
 */
public class MockResolutionFactory implements ResolutionFactory {

	/** true to write sent files to disk */
	//private boolean saveSentFiles = false;
	
	public ForwardResolution forward(String pageName) {
		return new MockResolution("forward", pageName);
	}

	public RedirectResolution redirect(String url) {
		return new MockResolution("redirect", url);
	}
	
	public RedirectResolution redirect(String action, String event) {
		UrlBuilder urlBuilder = new UrlBuilder();
		urlBuilder.setAction(action);
		urlBuilder.setEvent(event);
		return new MockResolution("redirect", urlBuilder);
	}
	
	public RedirectResolution redirect(Class<? extends Action> actionClass, String event) {
		return redirect(actionClass.getName(), event);
	}

	public PersistentFileResolution send(PersistentFile file) {
		throw new UnsupportedOperationException("Not yet implemented");
		//return new MockResolution(file, saveSentFiles);
	}

	public ForwardResolution forwardWithLocale(String pageName) {
		return forward(pageName);
	}
	
}
