/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.test;

import java.util.Iterator;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.loom.log.Log;
import org.loom.util.ClassUtils;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

/**
 * Tests the whole Hibernate JPA config, logging the persistent classes detected.
 * This test will fail if any column or relationship is not properly mapped.
 * It will not insert anything into any table, just perform a SELECT. The database
 * tables can be empty.
 * 
 * @author icoloma
 */
@RunWith(SpringJUnit4ClassRunner.class)
@Transactional
// Add your own annotation to your child class:
// @ContextConfiguration(locations={"classpath:spring-config.xml"})  
public abstract class AbstractHibernateTests extends AbstractTransactionalDataSourceSpringContextTests {

	private static Log log = Log.getLog();
	
	@PersistenceContext
	private EntityManager entityManager;
	
	public AbstractHibernateTests() {
		this.setDefaultRollback(false);
	}

	/**
	 * Test the mapping of all registered persistent classes
	 */
	@Test
	@SuppressWarnings("unchecked")
	public void testColumnMapping() throws Exception {
		Session session = (Session) entityManager.getDelegate();
		Map metadata = session.getSessionFactory().getAllClassMetadata();
		int count = 0;
		for (Iterator i = metadata.values().iterator(); i.hasNext();) {
			EntityPersister persister = (EntityPersister) i.next();
			String className = persister.getEntityName();
			if (ClassUtils.isAbstract(ClassUtils.forName(className))) {
				log.info("Skipping abstract class ", className);
			} else {
				log.info("select * from ", className);
				Query q = session.createQuery("from " + className);
				q.iterate();
				log.info("ok");
				count++;
			}
		}
		assertTrue("No persistent classes found", count > 0);
		
		// by default, hsqldb writes each 10 ms. It's a matter of using this or setting WRITE DELAY
		Thread.sleep(10);

	}

}