/*
 * Copyright 2002-2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.loom.test;


import org.junit.Assert;
import org.junit.Before;
import org.loom.config.Config;
import org.loom.i18n.Messages;
import org.loom.log.Log;
import org.loom.util.TestUtil;
import org.loom.validator.PropertyValidator;
import org.loom.validator.ValidationRequest;

/**
 * Parent class of Validator tests
 * @author icoloma
 *
 * @param <T> the Validator class
 */
public abstract class AbstractValidatorTests<T extends PropertyValidator> {

	/** the Validator instance */
	protected T validator;
	
	private Log log = Log.getLog();
	
	@Before
	public final void initConfig() {
		TestUtil.initConfig();
	}
	
	/**
	 * Check that validation of the provided object passes
	 * @param value the object value tovalidate
	 */
	protected void assertPass(Object value) {
		Messages e = new Messages();
		validator.validate(new ValidationRequest(validator, e), value);
		Assert.assertTrue(Config.getInstance() == null? null : TestUtil.toString(e), e.isEmpty());
		log.info("Validation pass (", value, ")"); 
	}
	
	/**
	 * Check that the validation of the provided object fails
	 * @param value the instance to validate
	 */
	protected void assertFail(Object value) {
		Messages e = new Messages();
		validator.validate(new ValidationRequest(validator, e), value);
		Assert.assertFalse(e.isEmpty());
		log.info("Validation fail (", value, "): ", TestUtil.toString(e));
	}
	
}
