/*
 * Decompiled with CFR 0.152.
 */
package org.loom.mock;

import java.util.HashMap;
import java.util.Map;
import org.loom.config.Config;
import org.loom.injection.DependencyInjectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockDependencyInjectionAdapter
implements DependencyInjectionAdapter {
    private Map<String, Object> beans = new HashMap<String, Object>();

    public Object getBean(String beanName) {
        return this.beans.get(beanName);
    }

    public void setBean(String name, Object value) {
        this.beans.put(name, value);
    }

    public <T> T getFirstBeanOfType(Class<T> clazz) {
        Map<String, T> m = this.getBeansOfType(clazz);
        return m.isEmpty() ? null : (T)m.entrySet().iterator().next().getValue();
    }

    public <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public String getProviderName() {
        return "Mock DI Provider";
    }

    public Config getConfig() {
        return null;
    }

    public boolean containsBean(String beanName) {
        return this.beans.containsKey(beanName);
    }
}

