/*
 * Decompiled with CFR 0.152.
 */
package org.loom.mock;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.jsp.JspWriter;

public class MockJspWriter
extends JspWriter {
    private StringWriter writer = new StringWriter();

    protected MockJspWriter() {
        super(1000, false);
    }

    public void flush() throws IOException {
        this.writer.flush();
        System.out.println(this.writer.getBuffer().toString());
    }

    public String toString() {
        return this.writer.getBuffer().toString();
    }

    public void clear() throws IOException {
        this.writer = new StringWriter();
    }

    public void clearBuffer() throws IOException {
        this.writer = new StringWriter();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getRemaining() {
        return 0x40000000 - this.writer.getBuffer().length();
    }

    public void newLine() throws IOException {
        this.writer.append('\n');
    }

    public void print(boolean b) throws IOException {
        this.writer.append(Boolean.toString(b));
    }

    public void print(char c) throws IOException {
        this.writer.append(c);
    }

    public void print(int i) throws IOException {
        this.writer.append(Integer.toString(i));
    }

    public void print(long l) throws IOException {
        this.writer.append(Long.toString(l));
    }

    public void print(float f) throws IOException {
        this.writer.append(Float.toString(f));
    }

    public void print(double d) throws IOException {
        this.writer.append(Double.toString(d));
    }

    public void print(char[] s) throws IOException {
        this.writer.write(s);
    }

    public void print(String s) throws IOException {
        this.writer.write(s);
    }

    public void print(Object obj) throws IOException {
        this.writer.write(obj == null ? "null" : obj.toString());
    }

    public void println() throws IOException {
        this.writer.append('\n');
    }

    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public StringWriter getWriter() {
        return this.writer;
    }

    public void setWriter(StringWriter writer) {
        this.writer = writer;
    }
}

