/*
 * Decompiled with CFR 0.152.
 */
package org.loom.mock;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.loom.action.Action;
import org.loom.log.Log;
import org.loom.persistence.file.PersistentFile;
import org.loom.resolution.ForwardResolution;
import org.loom.resolution.RedirectResolution;
import org.loom.resolution.Resolution;
import org.loom.servlet.CacheControl;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.LoomServletResponse;
import org.loom.url.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResolution
implements Resolution,
RedirectResolution,
ForwardResolution {
    private String type;
    private UrlBuilder url;
    private PersistentFile file;
    private boolean writeFile;
    private CacheControl cacheControl;
    private static Log log = Log.getLog();
    private static MockResolution lastResolution;

    public static MockResolution getLastResolution() {
        return lastResolution;
    }

    public MockResolution(String type, String url) {
        this.type = type;
        this.url = new UrlBuilder();
        this.url.setRawUrl(url);
        lastResolution = this;
    }

    public MockResolution(String type, UrlBuilder builder) {
        this.type = type;
        this.url = builder;
        lastResolution = this;
    }

    public MockResolution(PersistentFile file, boolean writeFile) {
        this.file = file;
        this.writeFile = writeFile;
        lastResolution = this;
    }

    public MockResolution(Class<? extends Action> actionClass, String event) {
        lastResolution = this;
    }

    public void resolve(LoomServletRequest request, LoomServletResponse response) throws IOException, ServletException {
        if (this.url != null) {
            log.info(new Object[]{"Resolution ", this.type, ": ", this.url.getURL(request)});
        } else if (this.file != null) {
            log.info(new Object[]{"Resolution file sent: [", this.file.getFilename(), ", content-type=", this.file.getContentType(), ", file-size=", this.file.getFileSize(), "bytes]"});
            if (this.writeFile) {
                this.writeFile();
            }
        } else {
            throw new RuntimeException("All the resolution fields are empty. Specify a url or a file!");
        }
    }

    public String getForwardedUrl() {
        return this.url.getRawUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile() throws IOException, FileNotFoundException {
        File f = File.createTempFile("resolution", this.file.getFilename());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            IOUtils.copy((InputStream)this.file.getContents().getContentsAsStream(), (OutputStream)out);
        }
        catch (Throwable throwable) {
            log.info(new Object[]{"File contents are written to ", f.getAbsoluteFile()});
            IOUtils.closeQuietly((OutputStream)out);
            throw throwable;
        }
        log.info(new Object[]{"File contents are written to ", f.getAbsoluteFile()});
        IOUtils.closeQuietly((OutputStream)out);
    }

    public RedirectResolution addParameter(String name, Object value) {
        this.url.addParameter(name, value);
        return this;
    }

    public RedirectResolution addPropertyParameter(String property) {
        return this.addParameter(property, property + " value");
    }

    public RedirectResolution setHash(String anchor) {
        this.url.setHash(anchor);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public UrlBuilder getUrl() {
        return this.url;
    }

    public PersistentFile getFile() {
        return this.file;
    }

    public MockResolution setCacheControl(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }
}

